# README

## Code for Submission: Adversarial Robustness Overestimation and Instability in TRADES

### Folder Structure and Configuration
- config: .gin config files to specify training hyperparameters
- src: contains source code for training and evaluating a model
- Note: Before training or evaluating any models, modify the paths specified in "src/config.py" according to local setup

### Training a model
1. Change directory to src
2. Specify the experiment root folder, gin config file, cuda index, number of workers, batch size, and random seed in the following command.

```bash!
python train.py \
--description "<path_to_save_model>" \
--gin_config "<config_file_path>" \
--cuda <gpu cuda index> \
--num_workers <worker count for dataloader eg.16> \
--batch_size <batch_size eg.256> \
--seed <rand_seed> \
```
An example bash file, **src/run_example.sh**, that runs 10 training instances with incrementing random seed is included.

### Evaluate a model
1. Change directory to src
2. Specify the dataset type, model path, attack type, and attack hyperparameters in the following command.

```bash!
python robust_eval.py \
--dataset "<dataset_name: cifar10, cifar100, tiny-imagenet>" \
--model_type resnet18 (currently supports only resnet18)\
--activation_name relu (currently supports only relu)\
--model_path "<model_path>"" \
--attack_type <attack type: pgd, autoattack, square, apgd-ce, apgd-dlr, FAB> \
--steps <No. of attacker steps> \
--epsilon <perturbation distance permitted> \
--cuda "<gpu cuda index>"
```
An example bash file, **src/eval_example.sh**, that runs all six attacks on a checkpoint is included.

### Pretrained Checkpoints
Pretrained checkpoints for the cifar100 classification task with $\beta = 3$, $batch size = 256$, and no learning rate scheduling can be found through the following link.

https://zenodo.org/records/13863803?token=eyJhbGciOiJIUzUxMiJ9.eyJpZCI6IjliOWMzMWIxLWE3MjAtNDQ0Yy05NTUyLTAwODU2YWY0ZWE2ZSIsImRhdGEiOnt9LCJyYW5kb20iOiIwMjA2YmFhZDdlYWY4OGJjODI1M2MyYjdlZTgyNWNiYiJ9.iJt9YtJd_vEPzFD1-9gxRsZENYp-76APH4EF5D_dq8aQsmlnOMMlvFlbI4slHpvh457nUi0BTN4_sSIaNLBDPw


- **cifar100_3_256_regular_best_adv_score.pt**: Instance where no instability is displayed.
- **cifar100_3_256_unstable_best_adv_score.pt**: Instance where instability is displayed.
- **cifar100_3_256_fixed_best_adv_score.pt**: Instance where our solution was applied.


|        | Clean               | PGD-10              | AutoAttack          | Gap                   |
|--------|---------------------|---------------------|---------------------|-----------------------|
| Regular   | 0.5342 ± 0.0019     | 0.2440 ± 0.0006     | 0.2009 ± 0.0028     | 0.0431 ± 0.0033        |
| Unstable  | 0.5424 ± 0.0102     | 0.2763 ± 0.0133     | 0.1292 ± 0.0344     | **0.1471** ± 0.0455    |
| Fixed     | 0.5290 ± 0.0063     | 0.2450 ± 0.0023     | 0.1999 ± 0.0029     | **0.0451** ± 0.0032    |
